/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.HELPGenstatsScreen;
import com.quantumdata.autoupdate.SerialSetPortInfoScreen;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PCMCIAGenstatsScreen
extends UpgradeScreen
implements ActionListener {
    private final String btnCancelCmd = "CANCEL";
    private final String btnNextCmd = "NEXT";
    private final String btnBackCmd = "BACK";
    private final String btnHelpCmd = "HELP";
    private final String btnStatsSerialCmd = "SERIAL";
    private JTextField m_txtModelNumber;
    private JTextField m_txtFirmwareVersion;
    private JTextField m_txtBootRomVersion;
    private JTextField m_txtGatewareVersion1;
    private JTextField m_txtGatewareVersion2;
    private JTextField m_txtGatewareVersion3;
    private Device88X m_dev88X;
    private SerialSetPortInfoScreen m_SerialDataScreen = null;

    public PCMCIAGenstatsScreen(String string, AutoUpdateGUI autoUpdateGUI, Device88X device88X) {
        super(string, autoUpdateGUI);
        this.m_dev88X = device88X;
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying PCMCIA Genstats Window");
        super.finalize();
        this.m_txtModelNumber = null;
        this.m_txtFirmwareVersion = null;
        this.m_txtBootRomVersion = null;
        this.m_txtGatewareVersion1 = null;
        this.m_txtGatewareVersion2 = null;
        this.m_txtGatewareVersion3 = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        JLabel jLabel = new JLabel("Please obtain genstats information from the 88X Generator and enter the data below.");
        String string = this.m_dev88X.getModelNum();
        if (string == "") {
            string = "<Enter Model Number>";
        }
        JLabel jLabel2 = new JLabel("Model Number:");
        this.m_txtModelNumber = new JTextField(30);
        this.m_txtModelNumber.setToolTipText("Enter the 88X Generator Model Number Obtained from genstats");
        this.m_txtModelNumber.setText(string);
        this.m_txtModelNumber.requestFocusInWindow();
        this.m_txtModelNumber.setInputVerifier(new ModelNumVerifier());
        jLabel2.setLabelFor(this.m_txtModelNumber);
        this.m_txtModelNumber.addFocusListener(this);
        string = this.m_dev88X.getFirmwareVer();
        if (string == "") {
            string = "<Enter Firmware Version Number>";
        }
        JLabel jLabel3 = new JLabel("Firmware Version:");
        this.m_txtFirmwareVersion = new JTextField(30);
        this.m_txtFirmwareVersion.setToolTipText("Enter The 88X Generator's Firware Version Obtained from genstats");
        this.m_txtFirmwareVersion.setText(string);
        this.m_txtFirmwareVersion.setInputVerifier(new FirmwareVerVerifier());
        jLabel3.setLabelFor(this.m_txtFirmwareVersion);
        this.m_txtFirmwareVersion.addFocusListener(this);
        string = this.m_dev88X.getBootRomVer();
        if (string == "") {
            string = "<Enter Boot ROM Version Number>";
        }
        JLabel jLabel4 = new JLabel("Boot ROM Version:");
        this.m_txtBootRomVersion = new JTextField(30);
        this.m_txtBootRomVersion.setToolTipText("Enter The 88X Generator's Boot ROM Version Obtained from genstats");
        this.m_txtBootRomVersion.setText(string);
        this.m_txtBootRomVersion.setInputVerifier(new BootRomVerifier());
        jLabel4.setLabelFor(this.m_txtBootRomVersion);
        this.m_txtBootRomVersion.addFocusListener(this);
        string = this.m_dev88X.getGatewareVersion(0);
        if (string == "") {
            string = "<Enter Gateware Version Number>";
        }
        JLabel jLabel5 = new JLabel("Gateware Version 1:");
        this.m_txtGatewareVersion1 = new JTextField(30);
        this.m_txtGatewareVersion1.setToolTipText("Enter The 88X Generator's Gateware Version Obtained from genstats");
        this.m_txtGatewareVersion1.setText(string);
        this.m_txtGatewareVersion1.setInputVerifier(new GatewareVerifier(false));
        jLabel5.setLabelFor(this.m_txtGatewareVersion1);
        this.m_txtGatewareVersion1.addFocusListener(this);
        string = this.m_dev88X.getGatewareVersion(1);
        if (string == "") {
            string = "<Enter Gateware Version Number>";
        }
        JLabel jLabel6 = new JLabel("Gateware Version 2:");
        this.m_txtGatewareVersion2 = new JTextField(30);
        this.m_txtGatewareVersion2.setToolTipText("Enter The 88X Generator's Gateware Version Obtained from genstats");
        this.m_txtGatewareVersion2.setText(string);
        this.m_txtGatewareVersion2.setInputVerifier(new GatewareVerifier(true));
        jLabel6.setLabelFor(this.m_txtGatewareVersion2);
        this.m_txtGatewareVersion2.addFocusListener(this);
        string = this.m_dev88X.getGatewareVersion(2);
        if (string == "") {
            string = "<Enter Gateware Version Number>";
        }
        JLabel jLabel7 = new JLabel("Gateware Version 3:");
        this.m_txtGatewareVersion3 = new JTextField(30);
        this.m_txtGatewareVersion3.setToolTipText("Enter The 88X Generator's Gateware Version Obtained from genstats");
        this.m_txtGatewareVersion3.setText(string);
        this.m_txtGatewareVersion3.setInputVerifier(new GatewareVerifier(true));
        jLabel7.setLabelFor(this.m_txtGatewareVersion3);
        this.m_txtGatewareVersion3.addFocusListener(this);
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("<< Back");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('B');
        jButton2.setDefaultCapable(true);
        jButton2.setActionCommand("BACK");
        jButton2.addActionListener(actionListener);
        JButton jButton3 = new JButton("Next >>");
        jButton3.setVerticalTextPosition(0);
        jButton3.setHorizontalTextPosition(10);
        jButton3.setMnemonic('N');
        jButton3.setDefaultCapable(true);
        jButton3.setActionCommand("NEXT");
        jButton3.addActionListener(actionListener);
        JButton jButton4 = new JButton("How To Get Genstats Manually");
        jButton4.setVerticalTextPosition(0);
        jButton4.setHorizontalTextPosition(10);
        jButton4.setMnemonic('G');
        jButton4.setDefaultCapable(true);
        jButton4.setActionCommand("HELP");
        jButton4.addActionListener(actionListener);
        JButton jButton5 = new JButton("Get Genstats via Serial Port");
        jButton5.setVerticalTextPosition(0);
        jButton5.setHorizontalTextPosition(10);
        jButton5.setMnemonic('S');
        jButton5.setDefaultCapable(true);
        jButton5.setActionCommand("SERIAL");
        jButton5.setVisible(false);
        jButton5.addActionListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        int n2 = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtModelNumber, gridBagConstraints);
        jPanel.add(this.m_txtModelNumber);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtFirmwareVersion, gridBagConstraints);
        jPanel.add(this.m_txtFirmwareVersion);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtBootRomVersion, gridBagConstraints);
        jPanel.add(this.m_txtBootRomVersion);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtGatewareVersion1, gridBagConstraints);
        jPanel.add(this.m_txtGatewareVersion1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel.add(jLabel6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtGatewareVersion2, gridBagConstraints);
        jPanel.add(this.m_txtGatewareVersion2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        jPanel.add(jLabel7);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 2, n, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_txtGatewareVersion3, gridBagConstraints);
        jPanel.add(this.m_txtGatewareVersion3);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton5);
        jPanel2.add(jButton4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(0, 0, n, 4);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        JPanel jPanel4 = new JPanel();
        super.setLogo(jPanel4);
        container.add((Component)jPanel4, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public String getModelNum() {
        return this.m_txtModelNumber.getText();
    }

    public void setModelNum(String string) {
        this.m_txtModelNumber.setText(string);
    }

    public boolean isModelNumValid() {
        return this.m_txtModelNumber.getInputVerifier().verify(this.m_txtModelNumber);
    }

    public String getFirmwareVersion() {
        return this.m_txtFirmwareVersion.getText();
    }

    public void setFirmwareVersion(String string) {
        this.m_txtFirmwareVersion.setText(string);
    }

    public boolean isFirmwareNumValid() {
        return this.m_txtFirmwareVersion.getInputVerifier().verify(this.m_txtFirmwareVersion);
    }

    public String getBootRomVersion() {
        return this.m_txtBootRomVersion.getText();
    }

    public void setBootRomVersion(String string) {
        this.m_txtBootRomVersion.setText(string);
    }

    public boolean isBootRomNumValid() {
        return this.m_txtBootRomVersion.getInputVerifier().verify(this.m_txtBootRomVersion);
    }

    public String getGatewareVer1() {
        return this.m_txtGatewareVersion1.getText();
    }

    public void setGatewareVer1(String string) {
        this.m_txtGatewareVersion1.setText(string);
    }

    public boolean isGatewareVer1Valid() {
        return this.m_txtGatewareVersion1.getInputVerifier().verify(this.m_txtGatewareVersion1);
    }

    public String getGatewareVer2() {
        return this.m_txtGatewareVersion2.getText();
    }

    public void setGatewareVer2(String string) {
        this.m_txtGatewareVersion2.setText(string);
    }

    public boolean isGatewareVer2Valid() {
        return this.m_txtGatewareVersion2.getInputVerifier().verify(this.m_txtGatewareVersion2);
    }

    public String getGatewareVer3() {
        return this.m_txtGatewareVersion3.getText();
    }

    public void setGatewareVer3(String string) {
        this.m_txtGatewareVersion3.setText(string);
    }

    public boolean isGatewareVer3Valid() {
        return this.m_txtGatewareVersion3.getInputVerifier().verify(this.m_txtGatewareVersion3);
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("BACK".equalsIgnoreCase(actionEvent.getActionCommand())) {
            n2 = -1;
            System.out.println("Go Back to Screen: ID= " + n2);
        } else if ("HELP".equals(actionEvent.getActionCommand())) {
            System.out.println("Display Help Screen");
            HELPGenstatsScreen hELPGenstatsScreen = new HELPGenstatsScreen();
            hELPGenstatsScreen.pack();
            hELPGenstatsScreen.setVisible(true);
        } else if ("SERIAL".equals(actionEvent.getActionCommand())) {
            this.m_SerialDataScreen = new SerialSetPortInfoScreen(this, this.m_dev88X);
            this.m_SerialDataScreen.pack();
            this.m_SerialDataScreen.setVisible(true);
        } else if ("SDATA_AVAILABLE".equals(actionEvent.getActionCommand())) {
            if (this.m_SerialDataScreen != null) {
                this.setModelNum(this.m_dev88X.getModelNum());
                this.setFirmwareVersion(this.m_dev88X.getFirmwareVer());
                this.setBootRomVersion(this.m_dev88X.getBootRomVer());
                this.setGatewareVer1(this.m_dev88X.getGatewareVersion(0));
                this.setGatewareVer2(this.m_dev88X.getGatewareVersion(1));
                this.setGatewareVer3(this.m_dev88X.getGatewareVersion(2));
                this.m_SerialDataScreen.setVisible(false);
            }
        } else {
            n2 = this.VerifyAndSetData(n, device88X);
            System.out.println("Next State " + n2);
        }
        return n2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("SERIAL".equals(actionEvent.getActionCommand())) {
            this.m_SerialDataScreen = new SerialSetPortInfoScreen(this, this.m_dev88X);
            this.m_SerialDataScreen.pack();
            this.m_SerialDataScreen.setVisible(true);
        }
        if ("SDATA_AVAILABLE".equals(actionEvent.getActionCommand()) && this.m_SerialDataScreen != null) {
            this.setModelNum(this.m_dev88X.getModelNum());
            this.setFirmwareVersion(this.m_dev88X.getFirmwareVer());
            this.setBootRomVersion(this.m_dev88X.getBootRomVer());
            this.setGatewareVer1(this.m_dev88X.getGatewareVersion(0));
            this.setGatewareVer2(this.m_dev88X.getGatewareVersion(1));
            this.setGatewareVer3(this.m_dev88X.getGatewareVersion(2));
            this.m_SerialDataScreen.setVisible(false);
        }
    }

    private int VerifyAndSetData(int n, Device88X device88X) {
        int n2 = n;
        if (!this.isModelNumValid()) {
            JOptionPane.showMessageDialog(null, "Invalid Model Number Entered\nShould be in the form of \"<Model>-<option>-<option>...\"\nExample: 882E-AN-CEC-TME-HDCP", "Invalid Data", 3);
            return n2;
        }
        device88X.setModelNum(this.getModelNum());
        if (!this.isFirmwareNumValid()) {
            JOptionPane.showMessageDialog(null, "Invalid Firmware Version Entered\nShould be in the form of NN.NNNNNNN\nExample: 20.1885600", "Invalid Data", 3);
            return n2;
        }
        device88X.setFirmwareVer(this.getFirmwareVersion());
        if (!this.isBootRomNumValid()) {
            JOptionPane.showMessageDialog(null, "Invalid Boot ROM Version Entered\nShould be in the form of NN.NN.NN\nExample: 01.04.11", "Invalid Data", 3);
            return n2;
        }
        device88X.setBootRomVer(this.getBootRomVersion());
        if (!this.isGatewareVer1Valid()) {
            JOptionPane.showMessageDialog(null, "Invalid Gateware 1 Version Entered\nShould be in the form of NNNX.N.NNNNNNN\nExample: 405C,4,2132008", "Invalid Data", 3);
            return n2;
        }
        device88X.setGatewareVersion(this.getGatewareVer1(), 0);
        if (!this.isGatewareVer2Valid()) {
            JOptionPane.showMessageDialog(null, "Invalid Gateware 2 Version Entered\nShould be in the form of NNNX.N.NNNNNNN\nExample: 405C,4,2132008", "Invalid Data", 3);
            return n2;
        }
        device88X.setGatewareVersion(this.getGatewareVer2(), 1);
        if (!this.isGatewareVer3Valid()) {
            JOptionPane.showMessageDialog(null, "Invalid Gateware 3 Version Entered\nShould be in the form of NNNX.N.NNNNNNN\nExample: 405C,4,2132008", "Invalid Data", 3);
            return n2;
        }
        device88X.setGatewareVersion(this.getGatewareVer3(), 2);
        n2 = 5;
        return n2;
    }

    private class GatewareVerifier
    extends InputVerifier {
        private boolean blankok;

        public GatewareVerifier(boolean bl) {
            this.blankok = bl;
        }

        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            if (string.equals("") && this.blankok) {
                return true;
            }
            String string2 = "^\\w{3,}\\,\\d{1,3}\\,\\d{7,8}";
            bl = string.matches(string2);
            return bl;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            this.verify(jComponent);
            return true;
        }
    }

    private class BootRomVerifier
    extends InputVerifier {
        private BootRomVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            String string2 = "^\\d{2}\\.\\d{2}\\.\\d{2}";
            bl = string.matches(string2);
            return bl;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            this.verify(jComponent);
            return true;
        }
    }

    private class FirmwareVerVerifier
    extends InputVerifier {
        private FirmwareVerVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            String string2 = "^\\d{1,}\\.\\d{7}";
            bl = string.matches(string2);
            return bl;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            this.verify(jComponent);
            return true;
        }
    }

    private class ModelNumVerifier
    extends InputVerifier {
        private ModelNumVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            String string2 = "^\\w{4,}[a-zA-Z\\-]*";
            bl = string.matches(string2);
            return bl;
        }

        public boolean shouldYieldFocus(JComponent jComponent) {
            this.verify(jComponent);
            return true;
        }
    }
}

